/****** Object:  StoredProcedure [dbo].[P_RC_DEB_HISTORICO_FILIAL]    Script Date: 03/26/2014 10:46:14 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_RC_DEB_HISTORICO_FILIAL]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_RC_DEB_HISTORICO_FILIAL]
GO
/****** Object:  StoredProcedure [dbo].[P_RC_DEB_HISTORICO_FILIAL]    Script Date: 17/02/2016 16:55:27 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- exec P_RC_DEB_HISTORICO_FILIAL 1,15,'2017-02-09'
CREATE PROCEDURE [dbo].[P_RC_DEB_HISTORICO_FILIAL] @CD_EMP INT=1, @CD_FILIAL INT, @DT_PROC DATETIME=NULL WITH ENCRYPTION AS 
SET NOCOUNT ON
DECLARE @CD_CTR INT
DECLARE @DT_ATUAL DATETIME 
SET @DT_ATUAL=GETDATE()

IF @DT_PROC IS NULL 
begin
	SET @DT_PROC = CONVERT(CHAR(10),GETDATE(),112)
end

CREATE TABLE #RSRECEBER (CD_EMP INT, CD_FILIAL INT, CD_RC_DEB INT, VLR_DP MONEY, VLR_SLD MONEY)
CREATE TABLE #RSRECEBERRECEBIMENTO (CD_EMP INT, CD_FILIAL INT, CD_RC_DEB INT, VLR_PGTO MONEY)
--Gerando contas a pagar da filial
INSERT INTO #RSRECEBER
SELECT
	CD_EMP,
	CD_FILIAL,
	CD_RC_DEB,
	ROUND(VLR_DP,2),
	ROUND(VLR_DP,2)
FROM
	RC_DEB
WHERE
	CD_EMP =@CD_EMP
	AND CD_FILIAL = @CD_FILIAL
	AND DT_DP<=@DT_PROC
	AND NOT STS_DP IN (3,4,6)
	
--Gerando recebimentos do contas a pagar
INSERT INTO #RSRECEBERRECEBIMENTO
SELECT
	R.CD_EMP,
	R.CD_FILIAL,
	R.CD_RC_DEB,
	SUM(ROUND(R.VL_PGTO,2)) AS VLR_PGTO
FROM
	RC_CRED R INNER JOIN RC_DEB P ON
	R.CD_EMP = P.CD_EMP AND
	R.CD_FILIAL = P.CD_FILIAL AND
	R.CD_RC_DEB = P.CD_RC_DEB
WHERE
	R.CD_EMP =@CD_EMP
	AND R.CD_FILIAL =@CD_FILIAL
	AND R.DT_PAG <=@DT_PROC
GROUP BY
	R.CD_EMP,
	R.CD_FILIAL,
	R.CD_RC_DEB

DELETE
	P
FROM
	#RSRECEBER P LEFT OUTER JOIN #RSRECEBERRECEBIMENTO R ON
	P.CD_EMP = R.CD_EMP AND
	P.CD_FILIAL = R.CD_FILIAL AND
	P.CD_RC_DEB=R.CD_RC_DEB
WHERE
	(p.VLR_DP-ISNULL(r.VLR_PGTO,0)) = 0

UPDATE
	P
SET 
	VLR_SLD = (p.VLR_DP-ISNULL(r.VLR_PGTO,0))
FROM
	#RSRECEBER P INNER JOIN #RSRECEBERRECEBIMENTO R ON
	P.CD_EMP = R.CD_EMP AND
	P.CD_FILIAL = R.CD_FILIAL AND
	P.CD_RC_DEB=R.CD_RC_DEB
WHERE
	(p.VLR_DP-ISNULL(r.VLR_PGTO,0)) <> 0

SET @CD_CTR=ISNULL((SELECT 
	MAX(CD_CTR)
FROM
	RC_DEB_HISTORICO
WHERE
	DT_PROC=@DT_PROC),0)

IF @CD_CTR > 0
begin
	DELETE 
		FROM RC_DEB_HISTORICO_CPL
	WHERE
		CD_EMP =@CD_EMP
		AND CD_FILIAL=@CD_FILIAL
		AND CD_CTR=@CD_CTR

	PRINT 'Lote atual.: ' + CONVERT(VARCHAR, @CD_CTR) + ' contas a receber ' + convert(varchar,getdate(),108)
end

IF @CD_CTR=0
begin
	INSERT INTO RC_DEB_HISTORICO (DT_PROC,DT_CAD)
	SELECT
		@DT_PROC,
		@DT_ATUAL

	SET @CD_CTR = IDENT_CURRENT( 'RC_DEB_HISTORICO' )
	PRINT 'Lote novo.: ' + CONVERT(VARCHAR, @CD_CTR) + ' contas a receber ' + convert(varchar,getdate(),108)
end

INSERT INTO RC_DEB_HISTORICO_CPL (
	CD_CTR,
	CD_EMP,
	CD_FILIAL,
	CD_RC_DEB,
	VLR_DP,
	DT_VENCTO,
	SLD_DP,
	STS_DP,
	COB,
	NR_BOLETA,
	CD_HIST,
	VLR_COMIS_CARTAO,
	VLR_DESC,
	DT_PRORROG,
	PERC_JUROS,
	VLR_IMP,
	VLR_GLOSA,
	CD_CLI,
	NR_DP,
	ANO,
	PARC,
	DT_DP,
	DT_CAD,
	CD_BC,
	STS_NF,
	VLR_IMPOSTO,
	FLAG_CONVENIO,
	FLAG_ADM_CARTAO,
	FLAG_CONTRATO_VERBA)
SELECT
	@CD_CTR,      
	a.CD_EMP,
	a.CD_FILIAL,
	a.CD_RC_DEB,
	a.VLR_DP,
	a.DT_VENCTO,
	p.VLR_SLD,
	a.STS_DP,
	a.COB,
	a.NR_BOLETA,
	a.CD_HIST,
	a.VLR_COMIS_CARTAO,
	isnull(a.VLR_DESC,0),
	a.DT_PRORROG,
	isnull(a.PERC_JUROS,0),
	isnull(a.VLR_IMP,0),
	isnull(a.VLR_GLOSA,0),
	a.CD_CLI,
	a.NR_DP,
	a.ANO,
	a.PARC,
	a.DT_DP,
	a.DT_CAD,
	a.CD_BC,
	a.STS_NF,
	ISNULL(V_RC_DEB_IMPOSTO.VLR_IMP,0),
	CASE WHEN RC_CLI_CONV_VINC_RC_CLI.CD_CLI IS NULL THEN
		0
	ELSE
		1
	END AS FLAG_CONVENIO,
	CASE WHEN RC_ADM_CARTAO_RC_CLI.CD_CLI IS NULL THEN
		0
	ELSE
		1
	END AS FLAG_ADM_CARTAO,
	CASE WHEN CG_FND_VERBA_RC_DEB_DUP_NR_CTR.CD_FND_VERBA IS NULL THEN
		0
	ELSE
		1
	END AS FLAG_CONTRATO_VERBA
FROM         
	RC_DEB a 
	INNER JOIN #RSRECEBER p ON 
	a.CD_EMP = p.CD_EMP AND
	a.CD_FILIAL = p.CD_FILIAL AND
	a.CD_RC_DEB = p.CD_RC_DEB
	LEFT OUTER JOIN V_RC_DEB_IMPOSTO ON
	a.CD_EMP = V_RC_DEB_IMPOSTO.CD_EMP AND
	a.CD_FILIAL = V_RC_DEB_IMPOSTO.CD_FILIAL AND
	a.CD_RC_DEB = V_RC_DEB_IMPOSTO.CD_RC_DEB
	LEFT OUTER JOIN
    (SELECT 
		DISTINCT CD_EMP, 
		CD_CLI 
    FROM 
    RC_CLI_CONV_VINC_RC_CLI) RC_CLI_CONV_VINC_RC_CLI ON
    a.CD_EMP = RC_CLI_CONV_VINC_RC_CLI.CD_EMP AND 
    a.CD_CLI = RC_CLI_CONV_VINC_RC_CLI.CD_CLI
	
	LEFT OUTER JOIN 
	(SELECT
		DISTINCT CD_EMP,
		CD_CLI
	FROM
		RC_ADM_CARTAO_RC_CLI)
	RC_ADM_CARTAO_RC_CLI ON
    a.CD_EMP = RC_ADM_CARTAO_RC_CLI.CD_EMP AND 
    a.CD_CLI = RC_ADM_CARTAO_RC_CLI.CD_CLI

	LEFT OUTER JOIN CG_FND_VERBA_RC_DEB_DUP_NR_CTR ON
    a.CD_EMP = CG_FND_VERBA_RC_DEB_DUP_NR_CTR.CD_EMP AND
    a.CD_FILIAL = CG_FND_VERBA_RC_DEB_DUP_NR_CTR.CD_FILIAL AND
    a.NR_DP = CG_FND_VERBA_RC_DEB_DUP_NR_CTR.NR_DP AND
    a.ANO = CG_FND_VERBA_RC_DEB_DUP_NR_CTR.ANO

DROP TABLE #RSRECEBER
DROP TABLE #RSRECEBERRECEBIMENTO
